﻿Imports System.Data.SqlClient
Imports CrystalDecisions.CrystalReports.Engine
Imports CrystalDecisions.Shared
Public Class frmRejectedPurchaseRequest
    Dim rpt As New rptRejectedPoApproval()
    Dim deptDs, rejectReqDs As New DataSet
    Dim deptDa, rejectReqDa As SqlDataAdapter
    Dim deptCodeArray(500) As String
    Dim rejectPurCount As Integer
    Private Sub frmRejectedPurchaseRequest_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        Try
            Call Db_Connection()
            rejectPurCount = Val(txtRejecRurCount.Text)
            If rejectPurCount = 0 Then
                rejectReqDs.Reset()
                sql = "SELECT CONVERT(VARCHAR,A.PRQ_DATE,103) AS DATE,B.ITM_ITEMCODE,B.ITM_ITEMDESC,A.PRQ_QTY,D.USR_EMPNAME,E.DEPT_DEPTNAME,CONVERT(VARCHAR,A.PRQ_PRCHBEFORE,103) AS PUR_BEFORE FROM PURCHASE_REQUEST AS A LEFT JOIN ITEMS AS B ON B.ITM_ITEMCODE = A.PRQ_ITEMCODE LEFT JOIN ITEM_CATEGORY AS C ON C.CAT_CATEGORYID = B.ITM_CATID LEFT JOIN USER_MASTER AS D ON D.USR_EMPID = A.PRQ_REQUESTBY LEFT JOIN DEPARTMENT AS E ON E.DEPT_DEPTID = D.USR_DEPTID WHERE A.IS_DELETE=0 AND A.PRQ_STATUS = 4"
                rejectReqDa = New SqlDataAdapter(sql, Mycn)
                rejectReqDa.Fill(rejectReqDs, DBNAME)

                rpt.SetDataSource(rejectReqDs.Tables(DBNAME))
            Else
                rejectReqDs.Reset()
                sql = "SELECT TOP " & rejectPurCount & " CONVERT(VARCHAR,A.PRQ_DATE,103) AS DATE,B.ITM_ITEMCODE,B.ITM_ITEMDESC,A.PRQ_QTY,D.USR_EMPNAME,E.DEPT_DEPTNAME,CONVERT(VARCHAR,A.PRQ_PRCHBEFORE,103) AS PUR_BEFORE FROM PURCHASE_REQUEST AS A LEFT JOIN ITEMS AS B ON B.ITM_ITEMCODE = A.PRQ_ITEMCODE LEFT JOIN ITEM_CATEGORY AS C ON C.CAT_CATEGORYID = B.ITM_CATID LEFT JOIN USER_MASTER AS D ON D.USR_EMPID = A.PRQ_REQUESTBY LEFT JOIN DEPARTMENT AS E ON E.DEPT_DEPTID = D.USR_DEPTID WHERE A.IS_DELETE=0 AND A.PRQ_STATUS = 4 ORDER BY A.ID DESC "
                rejectReqDa = New SqlDataAdapter(sql, Mycn)
                rejectReqDa.Fill(rejectReqDs, DBNAME)

                rpt.SetDataSource(rejectReqDs.Tables(DBNAME))
            End If

            Dim objCompany As TextObject = DirectCast(rpt.ReportDefinition.Sections("Section2").ReportObjects("txtrptCompany"), TextObject)
            objCompany.Text = LGNCOMPNAME
            Dim objAddress As TextObject = DirectCast(rpt.ReportDefinition.Sections("Section2").ReportObjects("txtrptAddress"), TextObject)
            objAddress.Text = LGNCMPADDRESS
            CrystalReportViewer1.ReportSource = rpt
            LoadDepartment()
        Catch ex As Exception
            MsgBox(ex.Message)
        End Try

    End Sub

    Private Sub btnGetDetails_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnGetDetails.Click
        Try
            Dim deptCode As String

            If cmbDepartment.SelectedIndex = -1 Then
                deptCode = ""
            Else
                deptCode = "AND E.DEPT_DEPTID = '" & deptCodeArray(cmbDepartment.SelectedIndex) & "'"
            End If

            rejectReqDs.Reset()
            sql = "SELECT CONVERT(VARCHAR,A.PRQ_DATE,103) AS DATE,B.ITM_ITEMCODE,B.ITM_ITEMDESC,A.PRQ_QTY,D.USR_EMPNAME,E.DEPT_DEPTNAME,CONVERT(VARCHAR,A.PRQ_PRCHBEFORE,103) AS PUR_BEFORE FROM PURCHASE_REQUEST AS A LEFT JOIN ITEMS AS B ON B.ITM_ITEMCODE = A.PRQ_ITEMCODE LEFT JOIN ITEM_CATEGORY AS C ON C.CAT_CATEGORYID = B.ITM_CATID LEFT JOIN USER_MASTER AS D ON D.USR_EMPID = A.PRQ_REQUESTBY LEFT JOIN DEPARTMENT AS E ON E.DEPT_DEPTID = D.USR_DEPTID WHERE A.IS_DELETE=0 AND A.PRQ_STATUS = 4 " & deptCode & " AND A.PRQ_DATE BETWEEN '" & dtpFromDate.Value.ToString("MM/dd/yyyy") & "' AND '" & dtpToDate.Value.ToString("MM/dd/yyyy") & "' "
            rejectReqDa = New SqlDataAdapter(sql, Mycn)
            rejectReqDa.Fill(rejectReqDs, DBNAME)

            rpt.SetDataSource(rejectReqDs.Tables(DBNAME))

            CrystalReportViewer1.ReportSource = rpt
        Catch ex As Exception
            MsgBox(ex.Message)
        End Try

    End Sub
    Private Sub LoadDepartment()

        Try

            'LOAD DEPARTMENT
            sql = " SELECT DEPT_DEPTID, DEPT_DEPTNAME, CREATED_DATE FROM DEPARTMENT WHERE IS_DELETE = 0 "
            deptDa = New SqlDataAdapter(sql, Mycn)
            deptDa.Fill(deptDs, DBNAME)
            Dim rowCount = deptDs.Tables(DBNAME).Rows.Count
            cmbDepartment.Items.Clear()
            For i = 0 To rowCount - 1
                deptCodeArray(i) = deptDs.Tables(DBNAME).Rows(i).Item(0)
                cmbDepartment.Items.Add(deptDs.Tables(DBNAME).Rows(i).Item(1))
            Next
        Catch ex As Exception
            MsgBox(ex.Message)
        End Try

    End Sub
End Class